参考：[iOS 项目 自动打包+上传蒲公英+推送到钉钉群]
[@yehot](https://github.com/yehot) https://github.com/yehot/iOS-AutoPackage

## 一、打包要求

1. 自动打包；
2. 打出的 `ipa` 包上传到蒲公英；
3. 上传成功后，通知到钉钉开发群；

### 依赖：

1. `fastlane` 的 `gym` 模块 (用于打包 ipa 文件)；
2. `fastlane` 的 `sign` 模块 (非必须)；
3. 蒲公英和钉钉提供的 `webhook`；
4. `PlistBuddy` 解析 `plist` 文件（Mac 系统自带）;

## 二、使用说明：

使用此脚本的的话，需要修改`ios_package.sh`：

1. `IOS_SCHEME` 对应 `YourProject.xcworkspace` 的 `YourProject`
2. `PGY_API_KEY` 对应 `蒲公英 API KEY`
3. `PGY_USER_KEY` 对应 `蒲公英 API KEY`
4. `DD_HOST_URL` 对应 `https://oapi.dingtalk.com/robot/send?access_token=ABCD` 的 `ABCD`
5. `DD_ICON_URL` 对应 `https://appicon.pgyer.com/image/view/app_icons/abcd/120Y` 的 `abcd/120Y`
6. `DD_DOWN_URL` 对应 `http://www.pgyer.com/abcd` 的 `abcd`

```shell
# 执行打包：
sh [path/to]/ios_package.sh PRD yes
```

参数1：PRD 对应工程的环境文件，参数2：yes 代表使用钉钉通知，参数2：no 不使用钉钉通知

## 三、Tips:

打包依赖 `fastlane、gym` 安装：

```shell
# fastlane 安装：
sudo gem install fastlane --verbose
xcode-select --install
gem cleanup

# gym 安装：
sudo gem install gym
xcode-select --install
```

