#!/bin/bash
# 上传 ipa 到蒲公英

# echo util
readonly COLOR_Cyan=''
readonly COLOR_Red=''
readonly COLOR_Default=''

function echo_log() {
    echo "${COLOR_Cyan}$1${COLOR_Default}"
}

function echo_error() {
    echo "${COLOR_Red}$1${COLOR_Default}"
}

echo_log "===== 打包完成，开始上传到蒲公英 ====="

NOW=$(date +"%Y_%m_%d_%H_%M_%S")
PROJECT_PATH=$(dirname $(cd "$(dirname "$0")"; pwd))
PSCHEME_PATH=($(find $PROJECT_PATH -name *.xcodeproj))
PSCHEME_NAME=${PSCHEME_PATH##*/}
EBIZ_SCHEME=(${PSCHEME_NAME//./ })
CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)
EBIZ_IPA_PATH=$1
EBIZ_ENV=$2
EBIZ_BUILD_NUMBER=$3
PGY_API_KEY=$4
PGY_USER_KEY=$5
DD_HOST_URL=$6

if [ ! -n "${NOW}" ] ;then
    echo_error "auto-upload 入参 'now' 有误！"
    exit 1
else
    echo "构建时间: ${NOW}"
fi

if [ ! -n "${EBIZ_IPA_PATH}" ] ;then
    echo_error "auto-upload 入参 'ipa_path' 有误！"
    exit 1
else
    if [ ! -f "${EBIZ_IPA_PATH}" ]; then
        echo_error "${EBIZ_IPA_PATH} 文件不存在"
        exit 1
    fi
    echo_log "ipa 文件 path 为 ${EBIZ_IPA_PATH}"
fi

# 测试 demo
# 采蜜 蒲公英 上传 key

PGY_UPLOAD_SERVER="https://qiniu-storage.pgyer.com/apiv1/app/upload"

# 接收键盘输入
# read -p "请输入蒲公英更新 log:" pgy_upload_log
# echo_log "更新 log 为：${pgy_upload_log}"
PGY_password="$(($RANDOM%9999+1111))"
PGY_upload_log="${EBIZ_ENV}_${NOW},${DD_MESSAGE}"

# 上传到蒲公英，并接收 Response
PGY_RESPONSE=`curl -F "file=@/${EBIZ_IPA_PATH}" -F "uKey=${PGY_USER_KEY}" -F "_api_key=${PGY_API_KEY}" -F installType=2 -F password="${PGY_password}" -F "updateDescription=${PGY_upload_log}" ${PGY_UPLOAD_SERVER}`
RESPONSE=${PGY_RESPONSE//\\n/}

RESPONSE_CODE=$(echo $RESPONSE | jq '.code')
DD_ICON_URL=$(echo $RESPONSE | jq '.data.appIcon')/120
DD_DOWN_URL=$(echo $RESPONSE | jq '.data.appShortcutUrl')

if [ $RESPONSE_CODE -ne 0 ]; then
    echo_error "upload error"
    exit 1
fi

# 推送到钉钉机器人时显示打包的版本号
EBIZ_APP_Version=`/usr/libexec/PlistBuddy -c "Print CFBundleShortVersionString" ${PROJECT_PATH}/${EBIZ_SCHEME}/Info.plist`
EBIZ_APP_Name=`/usr/libexec/PlistBuddy -c "Print CFBundleDisplayName" ${PROJECT_PATH}/${EBIZ_SCHEME}/Info.plist`
EBIZ_APP_Build_Version="${EBIZ_BUILD_NUMBER}"
EBIZ_Version="${EBIZ_APP_Version}(${EBIZ_APP_Build_Version})"

echo_log ${EBIZ_APP_Name}
echo_log ${EBIZ_Version}
echo_log ${PGY_password}

# (以上调试完成后，再打开以下注释)

if [ $# -ge 6 ]; then
    python ${CURRENT_DIR}/auto_push_ding_talk.py ${EBIZ_Version} ${EBIZ_APP_Name} ${EBIZ_ENV} ${DD_ICON_URL//\"/} ${DD_DOWN_URL//\"/} ${DD_HOST_URL} ${PGY_password}
fi 






