#!/bin/bash
# 使用 fastlane gym 自动打包 ipa

# echo util
COLOR_Cyan='\033[0;36m'
COLOR_Red='\033[41;37m'
COLOR_Default='\033[0;m'
# todo: 打包前先执行 pod install

# 计时
SECONDS=0
# DIR path
readonly CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)
readonly PROJECT_DIR=$(dirname $(cd "$(dirname "$0")"; pwd))
readonly OUTPUT_DIR=${PROJECT_DIR}/fastlane_build

PSCHEME_PATH=($(find $PROJECT_DIR -name *.xcodeproj)// /})
PSCHEME_NAME=${PSCHEME_PATH##*/}

WSCHEME_PATH=($(find $PROJECT_DIR -name *.xcworkspace)// /})
WSCHEME_NAME=${WSCHEME_PATH##*/}
echo $WSCHEME_NAME
# project scheme name
readonly EBIZ_SCHEME=(${PSCHEME_NAME//./ })
readonly EBIZ_WORKSPACE=(${WSCHEME_NAME//./ })
echo $EBIZ_WORKSPACE
# project workspace name
readonly EBIZ_WORKSPACE_PATH="${PROJECT_DIR}/${EBIZ_WORKSPACE}.xcworkspace"

readonly EBIZ_BUILD_ENV=$1
readonly EBIZ_BUILD_NUMBER=$2
readonly EBIZ_ENV_COPY_PATH="${PROJECT_DIR}/${EBIZ_SCHEME}/Config/Config-${EBIZ_BUILD_ENV}.plist"
readonly EBIZ_ENV_PATH="${PROJECT_DIR}/${EBIZ_SCHEME}/Config/Config.plist"

# product
readonly EBIZ_ARCHIVE_PATH="${OUTPUT_DIR}/${EBIZ_SCHEME}.xcarchive"
readonly EBIZ_IPA_NAME="${EBIZ_SCHEME}.ipa"
readonly EBIZ_IPA_PATH="${OUTPUT_DIR}/${EBIZ_IPA_NAME}"

# 打包方式 Debug 、Release
readonly EBIZ_BUILD_CONFIGURATION="Debug"

# 指定打包所使用的输出方式
# 目前支持app-store, package, ad-hoc, enterprise, development, 和developer-id，即xcodebuild的method参数

# -----------------------------
readonly EBIZ_EXPORT_METHOD="development" # demo 项目没有 app id，打包方式选择 development 才能打出 ipa
# readonly EBIZ_EXPORT_METHOD="ad-hoc"    # 正常开发阶段选择 ad-hoc 打包，发布目前是手动打包
# -----------------------------

readonly PGY_API_KEY=$3
readonly PGY_USER_KEY=$4
readonly DD_HOST_URL=$5
readonly DD_ICON_URL=$6
readonly DD_DOWN_URL=$7
readonly DD_MESSAGE=$8

function echo_log() {
    echo "${COLOR_Cyan}$1${COLOR_Default}"
}

function echo_error() {
    echo "${COLOR_Red}$1${COLOR_Default}"
}

if [ ! -n "${EBIZ_BUILD_ENV}" ] ;then
    echo_error "auto-package 入参 'env' 有误！"
    exit 1
fi

# 修改打包环境
if [ -f $EBIZ_ENV_COPY_PATH ];then
    echo "MARVINTEST-YES"
    cp -r ${EBIZ_ENV_COPY_PATH} ${EBIZ_ENV_PATH}
else
    echo "MARVINTEST-NO"
    echo $EBIZ_ENV_COPY_PATH
    exit 1
fi
# 清理打包路径
rm -rf ${PROJECT_DIR}/fastlane_build

#输出设定的变量值
echo_log "============ config list =============="
echo_log "1 build configuration = ${EBIZ_BUILD_ENV} ${EBIZ_BUILD_CONFIGURATION}"
echo_log "2 export method = ${EBIZ_EXPORT_METHOD}"
echo_log "3 workspace path = ${EBIZ_WORKSPACE_PATH}"
echo_log "4 scheme name = ${EBIZ_SCHEME}"
echo_log "5 archive path = ${EBIZ_ARCHIVE_PATH}"
echo_log "6 ipa path = ${EBIZ_IPA_PATH}"
echo_log "7 ipa name = ${EBIZ_IPA_NAME}"
echo_log "======================================="

# 强制更新证书 (非必须)
# readonly APPLE_ID="xxxxxx@xxxx.com"
# fastlane sigh download_all -u 
${APPLE_ID} --adhoc --force

# fastlane increment_build_number
# 先清空前一次build
fastlane gym --workspace ${EBIZ_WORKSPACE_PATH} \
            --scheme ${EBIZ_SCHEME} --clean \
            --configuration ${EBIZ_BUILD_CONFIGURATION} \
            --archive_path ${EBIZ_ARCHIVE_PATH} \
            --export_method ${EBIZ_EXPORT_METHOD} \
            --output_directory ${OUTPUT_DIR} \
            --output_name ${EBIZ_IPA_NAME}

if [ "$?" -ne "0" ]; then
    echo "build error 停止自动构建"
    exit 1
fi

# 清理打包文件
echo_log "===== 打包耗时：${SECONDS}s ====="
echo "===== 包路径：${EBIZ_IPA_PATH} ====="

# open ${OUTPUT_DIR}

# 上传到蒲公英 (以上调试完成后，再打开以下注释)
if [ "yes" == "$DD_MESSAGE" ]; then
    sh ${PROJECT_DIR}/ipa_script/auto_upload_pgy.sh ${EBIZ_IPA_PATH} ${EBIZ_BUILD_ENV} ${EBIZ_BUILD_NUMBER} ${PGY_API_KEY} ${PGY_USER_KEY} ${DD_HOST_URL} ${DD_ICON_URL} ${DD_DOWN_URL}
else
    sh ${PROJECT_DIR}/ipa_script/auto_upload_pgy.sh ${EBIZ_IPA_PATH} ${EBIZ_BUILD_ENV} ${EBIZ_BUILD_NUMBER} ${PGY_API_KEY} ${PGY_USER_KEY}
fi



