# PRD or DEV or UAT，与环境文件对应
BUILD_ENV=$(echo $1 | tr '[a-z]' '[A-Z]')
# yes or no
DD_MESSAGE=$(echo $2 | tr '[A-Z]' '[a-z]')


if [ ! -n "${BUILD_ENV}" ] ;then
    echo "入参 'BUILD_ENV' 有误！"
    exit 1
fi

if [ ! -n "${DD_MESSAGE}" ] ;then
    echo "入参 'DD_MESSAGE' 有误！"
    exit 1
fi

# 代码分支
CODE_BRANCH="master"
# 代码仓库
CODE_SOURCE="http://用户名:密码@仓库地址"

# 脚本仓库
SCRIPT_SOURCE="http://112.124.100.131/app/iOS-AutoPackage.git"

# 蒲公英 API KEY #
PGY_API_KEY=""
# 蒲公英 USER KEY #
PGY_USER_KEY=""
# 钉钉 机器人 webhook 链接的 access_token 参数值 #
DD_HOST_URL=""
# 蒲公英 APP 图标 #
DD_ICON_URL=""
# 蒲公英 APP 关键字 #
DD_DOWN_URL=""

# 不要改 #
WORKSPACE="/Users/${USER}/AutoPackage/iOS/CODE"
# 不要改 #
SCRIPT_PATH="/Users/${USER}/AutoPackage/iOS/SCRIPT"

rm -rf ${WORKSPACE}
rm -rf ${SCRIPT_PATH}
git clone -b ${CODE_BRANCH} ${CODE_SOURCE} ${WORKSPACE}
git clone ${SCRIPT_SOURCE} ${SCRIPT_PATH}

PSCHEME_PATH=($(find $WORKSPACE -name *.xcodeproj)// /})
PSCHEME_NAME=${PSCHEME_PATH##*/}
IOS_SCHEME=(${PSCHEME_NAME//./ })
BUILD_NUMBER=`/usr/libexec/PlistBuddy -c "Print CFBundleVersion" ${WORKSPACE}/${IOS_SCHEME}/Info.plist`

cp -r ${SCRIPT_PATH}/ipa_script ${WORKSPACE}

sh ${WORKSPACE}/ipa_script/auto_package_ipa.sh ${BUILD_ENV} ${BUILD_NUMBER} ${PGY_API_KEY} ${PGY_USER_KEY} ${DD_HOST_URL} ${DD_ICON_URL} ${DD_DOWN_URL} ${DD_MESSAGE}
