
BUILD_ENV=$1
BUILD_TYPE=$2
PGY_API_KEY=$3
PGY_USER_KEY=$4
DD_HOST_URL=$5
DD_MESSAGE=$6

COLOR_Cyan='\033[0;36m'
COLOR_Red='\033[41;37m'
COLOR_Default='\033[0;m'

function echo_log() {
    echo "${COLOR_Cyan}$1${COLOR_Default}"
}

function echo_error() {
    echo "${COLOR_Red}$1${COLOR_Default}"
}

# 计时
SECONDS=0

PROJECT_DIR=$(dirname $(cd "$(dirname "$0")"; pwd))

echo_log "============ config list =============="
echo_log "1 build configuration = ${BUILD_ENV} ${BUILD_TYPE}"
echo_log "2 workspace path = ${PROJECT_DIR}"
echo_log "======================================="

# 打包命令
cd ${PROJECT_DIR}
gradle clean
gradle assemble${BUILD_TYPE}

APK_PATH=($(find ${PROJECT_DIR}/app/build -name *.apk))

APK_INFO=$(aapt d badging $APK_PATH | grep package)
APK_INFO=(${APK_INFO/ / })
VERSION=(${APK_INFO[2]/=/ })
BUILD_NUMBER=${VERSION[1]//\'/}

echo_log "===== 打包耗时：${SECONDS}s ====="

# 上传到蒲公英 (以上调试完成后，再打开以下注释)
if [ "yes" == "$DD_MESSAGE" ]; then
	sh ${PROJECT_DIR}/apk_script/auto_upload_pgy.sh ${APK_PATH} ${BUILD_ENV} ${BUILD_NUMBER} ${PGY_API_KEY} ${PGY_USER_KEY} ${DD_HOST_URL}
else
	sh ${PROJECT_DIR}/apk_script/auto_upload_pgy.sh ${APK_PATH} ${BUILD_ENV} ${BUILD_NUMBER} ${PGY_API_KEY} ${PGY_USER_KEY}
fi


